
function setStatus(state, topicText) {
  const dot = document.getElementById("statusDot");
  const text = document.getElementById("statusText");
  dot.className = "dot " + state;
  if (state === "disabled") {
    text.textContent = "Disabled";
  } else if (state === "connected") {
    text.textContent = "Connected";
  } else {
    text.textContent = "Disconnected";
  }
  document.getElementById("topic").textContent = topicText || "n/a";
}

function setToggle(enabled) {
  const btn = document.getElementById("toggleBtn");
  if (enabled) {
    btn.textContent = "Stop service";
    btn.classList.remove("start"); btn.classList.add("stop");
  } else {
    btn.textContent = "Start service";
    btn.classList.remove("stop"); btn.classList.add("start");
  }
}

async function refreshUI() {
  const s = await chrome.storage.local.get({ enabled: true, ws: "ws://localhost:8765/ws", alias: "" });
  document.getElementById("ws").value = s.ws;
  document.getElementById("alias").value = s.alias || "";
  setToggle(!!s.enabled);

  const status = await chrome.runtime.sendMessage({ type: "GET_STATUS" });
  const state = status?.enabled === false ? "disabled" :
                status?.connected ? "connected" : "disconnected";
  setStatus(state, status?.topic || "n/a");
}

document.addEventListener("DOMContentLoaded", () => {
  refreshUI();

  document.getElementById("toggleBtn").addEventListener("click", async () => {
    const s = await chrome.storage.local.get({ enabled: true });
    const next = !s.enabled;
    await chrome.runtime.sendMessage({ type: "SET_ENABLED", enabled: next });
    await refreshUI();
  });

  document.getElementById("reconnectBtn").addEventListener("click", async () => {
    await chrome.runtime.sendMessage({ type: "RECONNECT_NOW" });
    setTimeout(refreshUI, 500);
  });

  document.getElementById("save").addEventListener("click", async () => {
    const ws = document.getElementById("ws").value.trim();
    const alias = document.getElementById("alias").value.trim();
    await chrome.storage.local.set({ ws, alias });
    await chrome.runtime.sendMessage({ type: "RECONNECT_NOW" });
    setTimeout(refreshUI, 500);
  });
});
