import argparse
import torch
from internal.viewer.viewer import Viewer


def cli():
    # define arguments
    parser = argparse.ArgumentParser()
    parser.add_argument("model_paths", type=str, nargs="+")
    parser.add_argument("--host", "-a", type=str, default="0.0.0.0")
    parser.add_argument("--port", "-p", type=int, default=8080)
    parser.add_argument("--background_color", "--background_color", "--bkg_color", "-b",
                        type=str, nargs="+", default=["black"],
                        help="e.g.: white, black, 0 0 0, 1 1 1")
    parser.add_argument("--image_format", "--image-format", "-f", type=str, default="jpeg")
    parser.add_argument("--reorient", "-r", type=str, default="auto",
                        help="whether reorient the scene, available values: auto, enable, disable")
    parser.add_argument("--sh_degree", "--sh-degree", "--sh",
                        type=int, default=3)
    parser.add_argument("--enable_transform", "--enable-transform",
                        action="store_true", default=False,
                        help="Enable transform options on Web UI. May consume more memory")
    parser.add_argument("--show_cameras", "--show-cameras",
                        action="store_true")
    parser.add_argument("--cameras-json", "--cameras_json", type=str, default=None)
    parser.add_argument("--vanilla_deformable", action="store_true", default=False)
    parser.add_argument("--vanilla_gs4d", action="store_true", default=False)
    parser.add_argument("--vanilla_gs2d", action="store_true", default=False)
    parser.add_argument("--up", nargs=3, required=False, type=float, default=None)
    parser.add_argument("--default_camera_position", "--dcp", nargs=3, required=False, type=float, default=None)
    parser.add_argument("--default_camera_look_at", "--dcla", nargs=3, required=False, type=float, default=None)
    parser.add_argument("--no_edit_panel", action="store_true", default=False)
    parser.add_argument("--no_render_panel", action="store_true", default=False)
    parser.add_argument("--gsplat", action="store_true", default=False,
                        help="Use gsplat v1 renderer for ply file")
    parser.add_argument("--gsplat_aa", action="store_true", default=False,
                        help="Enable gsplat's anti-aliasing for ply file")
    parser.add_argument("--gsplat_v1_example", action="store_true", default=False,
                        help="Load checkpoint generated by the gsplat repo.")
    parser.add_argument("--gsplat_v1_example_aa", action="store_true", default=False,
                        help="Enable anti-aliased for the gsplat repo.'s model")
    parser.add_argument("--seganygs", type=str, default=None,
                        help="Path to a SegAnyGaussian model output directory or checkpoint file")
    parser.add_argument("--vanilla_seganygs", action="store_true", default=False)
    parser.add_argument("--vanilla_mip", action="store_true", default=False)
    parser.add_argument("--vanilla_pvg", action="store_true", default=False)
    parser.add_argument("--float32_matmul_precision", "--fp", type=str, default=None)
    args = parser.parse_args()

    # set torch float32_matmul_precision
    if args.float32_matmul_precision is not None:
        torch.set_float32_matmul_precision(args.float32_matmul_precision)
    del args.float32_matmul_precision

    # arguments post process
    if len(args.background_color) == 1 and isinstance(args.background_color[0], str):
        if args.background_color[0] == "white":
            args.background_color = (1., 1., 1.)
        else:
            args.background_color = (0., 0., 0.)
    else:
        args.background_color = tuple([float(i) for i in args.background_color])

    # create viewer
    viewer_init_args = {key: getattr(args, key) for key in vars(args)}
    viewer = Viewer(**viewer_init_args)

    # start viewer server
    viewer.start()
